<?php

class Ultimate_AI_TTS
{
  private $api_key;
  public $msg_ext;
  public function __construct()
  {
    $elevenlabs_key = get_option('ultimate_ai_elevenlabs_api_key', '');
    $this->api_key = $elevenlabs_key['api_key'] ?? "";

    $user_manager = new Ultimate_AI_User_Manager();

    $check_access = $user_manager->check_user_integration_access('elevenlabs');
    if($check_access['has_access']){
      $this->msg_ext = 'You can use yours from Profile > Integration.';
      if( isset($check_access['settings']['is_active'] )){
        if($check_access['settings']['is_active'] == 'true' ){
          $this->api_key = $check_access['settings']['api_key'];
        } 
      }
    }
  }

  public function baseURL(){
    return 'https://api.elevenlabs.io';
  }

  public function elevenlabs_get_voices()
  {
    // CHECK IF API KEY IS EMPTY
    if( empty( $this->api_key ) || !isset( $this->api_key ) ){
      return [
        'status' => 'fail',
        'message' => 'Empty Elevenlabs API key',
        'voices' => null,
      ];
    }
    $args = [
      'method' => 'GET',
      'headers' => [
        'Content-Type' => 'application/json',
        'xi-api-key' => $this->api_key,
      ],
    ];
  
    try {
      $response = wp_remote_post($this->baseURL() . '/v1/voices', $args);
      $res_body = json_decode(wp_remote_retrieve_body($response));

      $res_code = wp_remote_retrieve_response_code($response);

      if( $res_code == 200 ){
        return [
          'status' => 'success',
          'voices' => $res_body
        ];
      }else{        
        return [
          'status' => 'fail',
          'message' => $res_body->detail->message,
        ];
      }
    } catch (Exception $e) {
      return [
        'status' => 'fail',
        'message' => 'Error , ' . $e->getMessage(),
        'voices' => null,
      ];
    }
  }

  public function elevenlabs_create_voice($text_data){

    if( empty( $this->api_key ) || !isset( $this->api_key ) ){
      return [
        'status' => 'fail',
        'message' => 'Empty Elevenlabs API key. ' . $this->msg_ext,
        'voices' => null,
      ];
    }
    $model_id = $text_data['model_id'];
    $text = $text_data['text'];
    $voice_id = $text_data['voice_id'];
    $curl = curl_init();
    curl_setopt_array($curl, [
      CURLOPT_URL => 'https://api.elevenlabs.io/v1/text-to-speech/' . $voice_id . '/stream',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_NOBODY => false,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => json_encode([
        'model_id' => $model_id,
        'text' => $text,
        'voice_settings' => [
          'similarity_boost' => 0,
          'stability' => 0,
          'use_speaker_boost' => true,
        ],
      ]),
      CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'xi-api-key: ' . $this->api_key,
      ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

    if ($err) {
      return false;
    } elseif( $httpCode == 200 ) {
      $upload_dir = wp_upload_dir();
      $audio_dir = str_replace('/', DIRECTORY_SEPARATOR, $upload_dir['path']) . DIRECTORY_SEPARATOR;

      $unique_id = rand();
      // Create the name of the file 
      $file_name = 'ultiamate_ai_audio_' . $unique_id . '.mp3';

      //Save the file in the upload directory.
      $upload_file = file_put_contents($audio_dir . $file_name, $response);
      if ($upload_file == false) {
        return false;
      }


      $attachment = array(
        'post_mime_type' => "audio/mpeg",
        'post_title'     => 'ultiamate_ai_audio_' . $unique_id,
        'post_content'   => '',
        'post_status'    => 'inherit',
        'guid'           => $file_name,
        "meta_input"     => array(
          "tool_type" => "ultimate_ai_audio",
        ),
      );

      $attach_id = wp_insert_attachment($attachment, $upload_dir['path'] . '/' . $file_name);

      return [
        'status'  => 'success',
        'url'     => wp_get_attachment_url($attach_id)
      ];
    } else{
      return [
        'status'  => 'fail',
        'message' => esc_html__( 'Audio generation failed. Please check your API key is correct.', ULTIMATE_AI_SLUG ),
        'res'     => json_decode($response)
      ];
    }
  }
  
}
